VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "ArmToken"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
Private Declare Sub Sleep Lib "Kernel32" (ByVal dwMiliseconds As Long)

Private Const SEP1 As String = ""
Private Const SEP2 As String = ""
Private Const SEP As String = SEP1 + SEP2
Private Const SIFYB_CM_ERROR_MESSAGE = 8000                 ' const for base of error messages ids

Dim mb_Initialized  As Boolean           ' True if the component is already initialized
Dim mb_haveToken    As Boolean           ' internal token state
Dim ms_tokenName    As String
Dim ml_errCode      As ErrMsg
Dim ms_errMsg       As String


' **************************************************************************************************
' **************************************** USER DEFINED ERRORS *************************************
' **************************************************************************************************
Private Enum ArmErr
    DBCnxFailed = vbObjectError + 1             ' Unable to connect to the database
    CPTAlreadyInitialized = vbObjectError + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = vbObjectError + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = vbObjectError + 4
    PropertyNotSet = vbObjectError + 5
    CompFncFailed = vbObjectError + 6           ' when component function fail
    QuietException = vbObjectError + 7          ' do not display error message
    WarMsgSelectRow = vbObjectError + 8
    SQLBadRowAffectedCount = vbObjectError + 9  ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = vbObjectError + 10 ' A SQL request does not return the expected rowcount : select an item return nothing...
End Enum
Private Enum ErrMsg
    ErrMsg_M000 = SIFYB_CM_ERROR_MESSAGE + 0                ' undefined message
    ErrMsg_M661 = SIFYB_CM_ERROR_MESSAGE + 661              ' Some SPA are being submitting. Please wait a few moment and try again
    ErrMsg_M662 = SIFYB_CM_ERROR_MESSAGE + 662              ' The SPA configurations are being updated. Please wait a few moment and try again
End Enum

Public Enum eTokenType
    StandardToken
    SPA_Admin_ScreenValidate
End Enum

#If LIVE = 1 Then
    Dim mo_Db As Object
#Else
    Dim mo_Db As ARMSYSCOMLib.ArmDb
#End If

Public Property Get Initialized() As Boolean
    Initialized = mb_Initialized
End Property

Public Property Set Db(ByRef ao_DB As ArmDb)
On Error GoTo ErrHandler
    
    If Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    If ao_DB Is Nothing Then Call Err.Raise(ArmErr.InvalidArgument)
    
    Set mo_Db = ao_DB
    Exit Property
ErrHandler:
    Call ErrorHandler("ArmToken.Db(Set)")
End Property

Public Sub Load_A_Com()
On Error GoTo ErrHandler
    If Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    If mo_Db Is Nothing Then Call Err.Raise(ArmErr.PropertyNotSet, "", "mo_Db")
    
    mb_haveToken = False
    
    mb_Initialized = True
    Exit Sub
ErrHandler:
    Call ErrorHandler("ArmToken.Load_A_Com()")
End Sub

Public Sub UnLoad_A_Com()
On Error GoTo ErrHandler
    If Not Initialized Then Call Err.Raise(ArmErr.CPTNotInitialized)
    
    If mb_haveToken Then
        Call ReleaseToken

    End If
    
    Set mo_Db = Nothing

    mb_Initialized = False
    Exit Sub
ErrHandler:
    Call ErrorHandler("ArmToken.Unload_A_Com()")
End Sub

Public Property Get LastErrorCode() As Long
    LastErrorCode = ml_errCode
End Property

Public Property Get lastErrorMsg() As String
    lastErrorMsg = ms_errMsg
End Property

Public Property Get haveToken() As Boolean
    haveToken = mb_haveToken
End Property
Public Function GetToken(ByVal as_tokenName As String, ByVal al_tokenType As eTokenType) As Boolean
On Error GoTo ErrHandler
    Dim ll_aktToken As Long
    Dim ll_i As Long
    
    If mb_haveToken Then
        Call Err.Raise(ErrMsg_M000, "", "#You already have token.")
        Exit Function
    End If
    
    GetToken = False
    
    For ll_i = 0 To 4       ' 5 tryes
        ll_aktToken = ReadToken(as_tokenName)
        Select Case al_tokenType
            Case SPA_Admin_ScreenValidate   ' only if current token is 0
                If ll_aktToken = 0 Then
                    Call TakeToken(as_tokenName, -1)
                    mb_haveToken = True
                    ms_tokenName = as_tokenName
                    GetToken = True
                    Exit Function
                End If
            Case Else
                If ll_aktToken >= 0 Then
                    Call TakeToken(as_tokenName, ll_aktToken + 1)
                    mb_haveToken = True
                    ms_tokenName = as_tokenName
                    GetToken = True
                    Exit Function
                End If
        End Select
        Call Sleep(1000)        ' 1 sec
    Next
    
    If ll_aktToken > 0 Then
        ml_errCode = ErrMsg_M661
        ms_errMsg = "Some SPA are being submitting. Please wait a few moment and try again."
    Else
        ml_errCode = ErrMsg_M662
        ms_errMsg = "The SPA configurations are being updated. Please wait a few moment and try again."
    End If
    
    Exit Function
ErrHandler:
    Call ErrorHandler("ArmToken.GetToken()")
End Function

Public Sub ReleaseToken()
On Error GoTo ErrHandler
    If Not mb_haveToken Then Exit Sub

    Dim ll_aktToken As Long
    ll_aktToken = ReadToken(ms_tokenName)
    If ll_aktToken <= 0 Then
        ll_aktToken = 0
    Else
        ll_aktToken = ll_aktToken - 1
    End If
    
    Call TakeToken(ms_tokenName, ll_aktToken)
    mb_haveToken = False
    ms_tokenName = ""

    Exit Sub
ErrHandler:
    Call ErrorHandler("ArmToken.ReleaseToken()")
End Sub

Private Function ReadToken(ByVal as_tokenName As String) As Long
On Error GoTo ErrHandler
    Const C_REQ As String = "EXEC A_Config_sel $TOKEN_NAME$"
    Dim ll_Cursor As Long
    ReadToken = 0
    
    ll_Cursor = OpenSQLSafe(mo_Db, Replace(C_REQ, "$TOKEN_NAME$", SQLStr(as_tokenName, 20), , , vbTextCompare), 1)
    
    ReadToken = CLng(mo_Db.GetFields(ll_Cursor, "CFG_Value"))
    
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    Exit Function
ErrHandler:
    If ll_Cursor > 0 Then Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    Call ErrorHandler("ArmToken.GetToken()")
End Function

Private Sub TakeToken(ByVal as_tokenName As String, ByVal al_newValue As Long)
On Error GoTo ErrHandler
    Const C_REQ As String = "UPDATE A_Config SET CFG_Value=$VALUE$ WHERE CFG_key=$TOKEN_NAME$"
    Dim ls_req As String
    
    ls_req = Replace(C_REQ, "$TOKEN_NAME$", SQLStr(as_tokenName, 50), , , vbTextCompare)
    ls_req = Replace(ls_req, "$VALUE$", SQLStr(CStr(al_newValue), 100), , , vbTextCompare)
    
    Call ExecuteSQLSafe(mo_Db, ls_req, 1)

    Exit Sub
ErrHandler:
    Call ErrorHandler("ArmToken.TakeToken()")
End Sub


' ************************************************************************************
' **************************** DB-ACCESS FUNCTIONS ***********************************
' ************************************************************************************
#If LIVE = 1 Then
Private Sub ExecuteSQLSafe(ByVal ao_DB As Object, ByVal as_Request As String, Optional ByVal al_RowAffectedCount = -1)
#Else
Private Sub ExecuteSQLSafe(ByVal ao_DB As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowAffectedCount = -1)
#End If
On Error GoTo ErrHandler
    ' First execute the request
    If Not ao_DB.ExecuteSQL(as_Request) Then
        Call Err.Raise(CompFncFailed, "ao_Db.ExecuteSQL - " & "SQL : " & as_Request, "SQL Error: " & GetDbError(ao_DB))
    End If

    If al_RowAffectedCount <> -1 Then
        ' Then check the rowcount
        If ao_DB.SQLRowsAffected <> al_RowAffectedCount Then
            Call Err.Raise(SQLBadRowAffectedCount, "SQL : " & as_Request, al_RowAffectedCount & "<>" & ao_DB.SQLRowsAffected)
        End If
    End If
    Exit Sub
ErrHandler:
    Call ErrorHandler("ArmToken.ExecuteSQLSafe")
End Sub

#If LIVE = 1 Then
Private Function OpenSQLSafe(ByVal ao_DB As Object, ByVal as_Request As String, Optional ByVal al_RowExpectedCount = -1) As Long
#Else
Private Function OpenSQLSafe(ByVal ao_DB As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowExpectedCount = -1) As Long
#End If
On Error GoTo ErrHandler
    Dim lc_Data As Long
    lc_Data = ao_DB.OpenSQL(as_Request)
    If lc_Data = 0 Then
        Call Err.Raise(CompFncFailed, "ao_Db.OpenSQL - " & "SQL : " & as_Request, "SQL Error: " & GetDbError(ao_DB))
    End If
    
    If al_RowExpectedCount <> -1 Then
        ' Then check the rowcount
        If ao_DB.RowCount(lc_Data) <> al_RowExpectedCount Then
            Call Err.Raise(SQLBadRowExpectedCount, "SQL : " & as_Request, al_RowExpectedCount & "<>" & ao_DB.RowCount(lc_Data))
        End If
    End If
    OpenSQLSafe = lc_Data
    Exit Function
ErrHandler:
    Call ErrorHandler("ArmToken.OpenSQLSafe")
End Function

Private Function SQLStr(ByVal as_str As String, Optional ByVal al_MaxLen As Long = 8000) As String
On Error GoTo ErrHandler
    SQLStr = "'" & Replace(Left(as_str, IIf(Len(as_str) <= al_MaxLen, Len(as_str), al_MaxLen)), "'", "''") & "'"
    Exit Function
ErrHandler:
    Call ErrorHandler("ArmToken.SqlStr")
End Function

' ************************************************************************************
' ********************** ERROR-HANDLING SUPPORT FUNCTIONS ****************************
' ************************************************************************************
#If LIVE = 1 Then
Private Function GetDbError(ByVal lo_Db As Object) As String
#Else
Private Function GetDbError(ByVal lo_Db As ARMSYSCOMLib.ArmDb) As String
#End If
On Error GoTo ErrHandler
    If IsArray(lo_Db.SQLErrorMessages) Then
        Debug.Assert (IsArray(lo_Db.SQLErrorCodes))
        ' Display errors msgBox
        GetDbError = Join(lo_Db.SQLErrorCodes, ",") & vbCrLf & Join(lo_Db.SQLErrorMessages, vbCrLf)
    Else
        ' ExecuteSQL failed but no error message?
        GetDbError = "Unknown error"
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler("ArmToken.GetDbError()")
End Function

' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
    Call Err.Raise(Err.Number, as_Fct & SEP1 & Err.Source, Err.Description)
End Sub
